//
//
// GLTexture.h - Texture manager for OpenGL
//
//

#ifndef ATI_GLTEXTURE_H
#define ATI_GLTEXTURE_H

//Targa header info
typedef struct _TGAHeaderInfo
{
	unsigned char	idlen;		//length of optional identification sequence
	unsigned char	cmtype;		//indicates whether a palette is present
	unsigned char	imtype;		//image data type (e.g., uncompressed RGB)
	unsigned short cmorg;		//first palette index, if present
	unsigned short	cmcnt;		//number of palette entries, if present
	unsigned char	cmsize;		//number of bits per palette entry
	unsigned short	imxorg;		//horiz pixel coordinate of lower left of image
	unsigned short	imyorg;		//vert pixel coordinate of lower left of image
	unsigned short	imwidth;		//image width in pixels
	unsigned short	imheight;	//image height in pixels
	unsigned char	imdepth;		//image color depth (bits per pixel)
	unsigned char	imdesc;		//image attribute flags
}TGAHeaderInfo;


class ATI_GLTexture
{
	GLubyte		*m_textureData; // raw RGBA or RGB bits from (TGA) file...
	GLint		 	m_rawBPP;
	GLenum		m_textureFormat;
	GLint		 	m_internalFormat;
	GLboolean	m_textureIsMipMap;
	GLuint		m_textureName;
public:
	GLint		 m_textureWidth;
	GLint		 m_textureHeight;
	ATI_GLTexture(char *filename, GLint name, GLboolean mipMap, GLenum format, GLint internalFormat);
	~ATI_GLTexture(void);
	void Reload(char *filename, GLboolean mipMap, GLenum format, GLenum internalFormat);
	void Reformat(GLenum format, GLenum internalFormat);
	void QueryTexel(GLfloat floatX, GLfloat floatY, GLubyte *red, GLubyte *green, GLubyte *blue, GLubyte *alpha);
};


class ATI_GLCubemap
{
	GLubyte		*m_textureData; // raw RGBA or RGB bits from (TGA) file...
	GLint		 m_rawBPP;
	GLenum		 m_textureFormat;
	GLint		 m_internalFormat;
	GLboolean	 m_textureIsMipMap;
	GLuint		 m_textureName;
public:
	GLint		 m_textureWidth;
	GLint		 m_textureHeight;
	ATI_GLCubemap(char *filename, GLint name, GLboolean mipMap, GLenum format, GLint internalFormat);
	~ATI_GLCubemap(void);

        int ReadTGAFile (char *filename, TGAHeaderInfo *TGAHeader, 
                         GLubyte **textureData);
        int ReformatData (TGAHeaderInfo *TGAHeader, GLubyte *textureData,
                          GLenum format, GLubyte **outData);
};

#endif // ATI_GLTEXTURE_H

