#include <math.h>
#include <GL/glut.h>

#include <stdio.h>
#include "globals.h"

#include "matrix.h"

// prints the contents of a 16 element array to stdout
void matrixDebug (GLfloat matrix[16])
{
   fprintf(stdout, "|%f %f %f %f|\n", matrix[0], matrix[1], matrix[2], matrix[3]);
   fprintf(stdout, "|%f %f %f %f|\n", matrix[4], matrix[5], matrix[6], matrix[7]);
   fprintf(stdout, "|%f %f %f %f|\n", matrix[8], matrix[9], matrix[10], matrix[11]);
   fprintf(stdout, "|%f %f %f %f|\n\n", matrix[12], matrix[13], matrix[14], matrix[15]);

   return;
}

// prints the contents of a 4 element array to stdout
void vectorDebug (GLfloat vector[4])
{
   fprintf(stdout, "<%f, %f, %f, %f>\n", vector[0], vector[1], vector[2], vector[3]);
   
   return;
}

//////////////////////////
// Set matrix to identity
//   matrix - Input/Output matrix
//////////////////////////
void 
matrixIdentity(GLfloat matrix[16])
{
  matrix[ 0] = 1.0;  matrix[ 1] = 0.0;  matrix[ 2] = 0.0;  matrix[ 3] = 0.0;
  matrix[ 4] = 0.0;  matrix[ 5] = 1.0;  matrix[ 6] = 0.0;  matrix[ 7] = 0.0;
  matrix[ 8] = 0.0;  matrix[ 9] = 0.0;  matrix[10] = 1.0;  matrix[11] = 0.0;
  matrix[12] = 0.0;  matrix[13] = 0.0;  matrix[14] = 0.0;  matrix[15] = 1.0;
}

//////////////////////////
// Invert a matrix. (Matrix MUST be orhtonormal!)
//   in - Input matrix
//   out - Output matrix
//////////////////////////
void
matrixInvert(GLfloat in[16], GLfloat out[16])
{
  // Transpose rotation
  out[ 0] = in[ 0];  out[ 1] = in[ 4];  out[ 2] = in[ 8];
  out[ 4] = in[ 1];  out[ 5] = in[ 5];  out[ 6] = in[ 9];
  out[ 8] = in[ 2];  out[ 9] = in[ 6];  out[10] = in[10];
  
  // Clear shearing terms
  out[3] = 0.0f; out[7] = 0.0f; out[11] = 0.0f; out[15] = 1.0f;

  // Translation is minus the dot of tranlation and rotations
  out[12] = -(in[12]*in[ 0]) - (in[13]*in[ 1]) - (in[14]*in[ 2]);
  out[13] = -(in[12]*in[ 4]) - (in[13]*in[ 5]) - (in[14]*in[ 6]);
  out[14] = -(in[12]*in[ 8]) - (in[13]*in[ 9]) - (in[14]*in[10]);
}

//////////////////////////
// Multiply a vector by a matrix.
//   vecIn - Input vector
//   m - Input matrix
//   vecOut - Output vector
//////////////////////////
void
vecMatMult(GLfloat vecIn[3], GLfloat m[16], GLfloat vecOut[3]) {
  vecOut[0] = (vecIn[0]*m[ 0]) + (vecIn[1]*m[ 4]) + (vecIn[2]*m[ 8]) + m[12];
  vecOut[1] = (vecIn[0]*m[ 1]) + (vecIn[1]*m[ 5]) + (vecIn[2]*m[ 9]) + m[13];
  vecOut[2] = (vecIn[0]*m[ 2]) + (vecIn[1]*m[ 6]) + (vecIn[2]*m[10]) + m[14];
}


//////////////////////////
// Multiply a vector by just the 3x3 portion of a matrix.
//   vecIn - Input vector
//   m - Input matrix
//   vecOut - Output vector
//////////////////////////
void
vecMat3x3Mult(GLfloat vecIn[3], GLfloat m[16], GLfloat vecOut[3]) {
  vecOut[0] = (vecIn[0]*m[ 0]) + (vecIn[1]*m[ 4]) + (vecIn[2]*m[ 8]);
  vecOut[1] = (vecIn[0]*m[ 1]) + (vecIn[1]*m[ 5]) + (vecIn[2]*m[ 9]);
  vecOut[2] = (vecIn[0]*m[ 2]) + (vecIn[1]*m[ 6]) + (vecIn[2]*m[10]);
}


void vecCrossProd (GLfloat vecA[3], GLfloat vecB[3], GLfloat vecOut[3])
{
   vecOut[0] =  vecA[1]*vecB[2] - vecA[2]*vecB[1];
   vecOut[1] =  vecA[2]*vecB[0] - vecA[0]*vecB[2];
   vecOut[2] =  vecA[0]*vecB[1] - vecA[1]*vecB[0];
   
}

GLfloat vecNormalize (GLfloat vec[3])
{
   GLfloat mag = sqrt(vec[0]*vec[0] +
                      vec[1]*vec[1] +  
                      vec[2]*vec[2]);

   // don't divide by zero
   if ((mag > -0.0000001) && (mag < 0.0000001))
   {
      vec[0] = 0.0f;
      vec[1] = 0.0f;
      vec[2] = 0.0f;
      return(0.0f);
   }

   vec[0] /= mag;
   vec[1] /= mag;
   vec[2] /= mag;

   return(mag);
}

GLfloat vecDotProd (GLfloat vecA[3], GLfloat vecB[3])
{
   return(vecA[0]*vecB[0] +
          vecA[1]*vecB[1] +
          vecA[2]*vecB[2]);
   
}

void vecCopy (GLfloat vecIn[3], GLfloat vecOut[3])
{
   vecOut[0] = vecIn[0];
   vecOut[1] = vecIn[1];
   vecOut[2] = vecIn[2];

   return;   
}
