/******************************************************************************
 * filename: globals.c                                                        *
 *                                                                            *
 * author:   Christopher Oat                                                  *
 *           ATI Research, Inc.                                               *
 *           3D Application Research Group                                    *
 *           email: coat@ati.com                                              *
 *                                                                            *
 * description: contains global variables used by the program and referenced  *
 * as extern in globals.h                                                     *
 *                                                                            *
 ******************************************************************************
 $Header::                                                                    $
 ******************************************************************************
 *   (C) 2001 ATI Research, Inc.  All rights reserved.                        *
 ******************************************************************************/


// INCLUDES ====================================================================
#include <stdlib.h>
#include <stdio.h>
#include "globals.h"

// GLOBALS =====================================================================


// Prototypes needed.


GLfloat viewMatrix[16] = {1.0f, 0.0f, 0.0f, 0.0f,
                            0.0f, 1.0f, 0.0f, 0.0f,
                            0.0f, 0.0f, 1.0f, 0.0f,
                            0.0f, 0.0f, 0.0f, 1.0f};

GLfloat fov = 60.0;
GLfloat clipNear = 0.001;
GLfloat clipFar = 5000.0;
GLfloat scaleFactor = 1.0;
GLint screenWidth = 800;
GLint screenHeight = 600;


void printGlError (void)
{
   GLenum errCode;
   const GLubyte *errString;

   if ((errCode = glGetError()) != GL_NO_ERROR)
   {
      errString = gluErrorString(errCode);
      fprintf(stderr, "OpenGL Error: %s\n", errString);
   }

   return;
}