/******************************************************************************
 * filename: main.cpp                                                         *
 *                                                                            *
 * author:   Christopher Oat                                                  *
 *           ATI Research, Inc.                                               *
 *           3D Application Research Group                                    *
 *           email: coat@ati.com                                              *
 *                                                                            *
 * description: demos the use of per pixel diffuse lighting with dot3 bump    *
 *              mapping using glut and opengl.                                *
 *                                                                            *
 ******************************************************************************
 $Header::                                                                    $
 ******************************************************************************
 *   (C) 2001 ATI Research, Inc.  All rights reserved.                        *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glut.h>

#include "globals.h"
#include "callbacks.h"
#include "dot3.h"
#include "light.h"

static int mainExtensionSupported (const char *extension);
static void mainCheckExtensions (void);

int main(int argc, char **argv)
{
  glutInit(&argc, argv);

  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
  glutInitWindowSize(screenWidth,screenHeight);
  glutCreateWindow(argv[0]);

  glClear(GL_COLOR_BUFFER_BIT);

  glClearColor(0.0, 0.0, 0.0, 0.0);

  glEnable(GL_NORMALIZE); 
  glEnable(GL_DEPTH_TEST);

  callbacksInit();
  mainCheckExtensions();
  dot3Init();
  lightInit();
  
  glutMainLoop();

  return 0;             
}



/////////////////////////////////////
// Determine if a particular extension is supported
//   extension -- Name of the extension to check
/////////////////////////////////////
static int mainExtensionSupported (const char *extension)
{
  static const GLubyte *extensions = NULL;
  const GLubyte *start;
  GLubyte *where, *terminator;

  where = (GLubyte *) strchr(extension, ' ');
  if (where || *extension == '\0')
    return 0;

  if (!extensions)
    extensions = glGetString(GL_EXTENSIONS);

  start = extensions;
  for (;;) {
    where = (GLubyte *) strstr((const char *) start, extension);
    if (!where)
      break;
    terminator = where + strlen(extension);
    if (where == start || *(where - 1) == ' ') {
      if (*terminator == ' ' || *terminator == '\0') {
        return 1;
      }
    }
    start = terminator;
  }

  return 0;
}

/////////////////////////////////////
// Check to make sure the extensions we need are available.
/////////////////////////////////////
static void mainCheckExtensions (void)
{
  if (!mainExtensionSupported("GL_ARB_multitexture")){
    printf("No GL_ARB_multitexture support!\n");
    //Sleep(5000);
    exit(0);
  }

  if (!mainExtensionSupported("GL_ARB_texture_env_combine"))
  {
    printf("No GL_EXT_texture_env_combine support!\n");
    //Sleep(5000);
    exit(0);
  }
 
  return;
}
