/******************************************************************************
 * filename: dot3.h                                                           *
 *                                                                            *
 * author:   Christopher Oat                                                  *
 *           ATI Research, Inc.                                               *
 *           3D Application Research Group                                    *
 *           email: coat@ati.com                                              *
 *                                                                            *
 * description: loads textures and displays a textured quad with per pixel    *
 *              dot3 bump mapping.                                            *
 *                                                                            *
 ******************************************************************************
 $Header::                                                                    $
 ******************************************************************************
 *   (C) 2001 ATI Research, Inc.  All rights reserved.                        *
 ******************************************************************************/

#ifndef _DOT3_H
#define _DOT3_H

#define DOT3_WIREFRAME     0
#define DOT3_N_MAP_ONLY    1
#define DOT3_L_MAP_ONLY    2
#define DOT3_BASE_MAP_ONLY 3
#define DOT3_DOT3BUMP      4

void dot3Init (void);
void dot3Display (int tex, int mode);
void dot3DisplayVectors (void);
int dot3GetNumTex (void);

#endif