/**
* @file volfog_effect.h
*/

#ifndef _VOLFOG_EFFECT
#define _VOLFOG_EFFECT

#include "vector.h"

#include "weather_effect.h"
#include "glincl.h"

class VolFogEffect : public WeatherEffect
{
  ObjectListDeclaration(VolFogEffect);
public:
  VolFogEffect(const TiXmlElement* root = NULL);
  virtual ~VolFogEffect();

  virtual void loadParams(const TiXmlElement* root);

  virtual void init();

  virtual void activate();
  virtual void deactivate();
  
  inline  void activateFog()
  {
    this->activate();
  }
  inline  void deactivateFog()
  {
    this->deactivate();
  }

  virtual void draw() const;
  virtual void tick(float dt);

private:
  GLfloat fogColor[4];
  bool    fogActivate;

};

#endif  /* _VOLFOG_EFFECT */
