/*
  orxonox - the future of 3D-vertical-scrollers

  Copyright (C) 2006 orx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

### File Specific:
  main-programmer: hdavid
*/

#include "volfog_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "p_node.h"
#include "state.h"
#include "shell_command.h"

#include "glincl.h"
#include "debug.h"

#define GLX_GLXEXT_PROTOTYPES

#include "class_id_DEPRECATED.h"
ObjectListDefinitionID(VolFogEffect, CL_VOLFOG_EFFECT);
CREATE_FACTORY(VolFogEffect);

SHELL_COMMAND(activate, VolFogEffect, activateFog);
SHELL_COMMAND(deactivate, VolFogEffect, deactivateFog);


typedef void (APIENTRY * PFNGLFOGCOORDFEXTPROC) (GLfloat coord);    // Declare Function Prototype
PFNGLFOGCOORDFEXTPROC glFogCoordfEXT = NULL;          // Our glFogCoordfEXT Function


VolFogEffect::VolFogEffect(const TiXmlElement* root) {
  this->registerObject(this, VolFogEffect::_objectList);

  if (root != NULL)
      this->loadParams(root);

  // Initialize Effect
  this->init();

  // Activate Effect
  if(fogActivate)
    this->activate();
}


VolFogEffect::~VolFogEffect() {
  if(fogActivate)
    this->deactivate();
}

void VolFogEffect::loadParams(const TiXmlElement* root) {
  WeatherEffect::loadParams(root);
}

void VolFogEffect::init() {
  PRINTF(0)("Initalize VolFogEffect\n");
  
  fogColor[0] = 0.6f;
  fogColor[1] = 0.3f;
  fogColor[2] = 0.0f;
  fogColor[3] = 1.0f;

  fogActivate = false;
}


void VolFogEffect::activate() {
  PRINTF(0)("Activating VolFogEffect\n");
  
  // Test whether the extension exists
  if (!glewIsSupported("GL_EXT_fog_coord"))
  {
    PRINTF(0)("Can't activate volumetric fog, GL_EXT_fog_coord extension is misssing\n");
    return;
  }
  
  fogActivate = true;
}

void VolFogEffect::deactivate() {
  PRINTF(0)("Deactivating VolFogEffect\n");
  
  fogActivate = false;
}


/**
* draws the effect
*/
void VolFogEffect::draw() const {

  if(!fogActivate)
    return;
}


/**
* ticks the effect if there is any time dependancy
*/
void VolFogEffect::tick(float dt) {}
