/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "laser.h"

#include "state.h"
#include "model.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"

#include <cassert>
#include "debug.h"



ObjectListDefinition(Laser);
CREATE_FAST_FACTORY_STATIC(Laser);

/**
 *  standard constructor
*/
Laser::Laser () : Projectile()
{
  this->registerObject(this, Laser::_objectList);

  this->loadModel("models/projectiles/laser.obj");

  this->setMinEnergy(10);
  this->setHealthMax(0);
  this->lifeSpan = 5.0;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
  this->emitter->setEmissionRate(300.0);
  this->emitter->setEmissionVelocity(50.0);
}


/**
 *  standard deconstructor
*/
Laser::~Laser ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (Laser::explosionParticles != NULL && Laser::objectList().size() <= 1)
  {
    //if (ClassList::exists(Laser::explosionParticles, CL_PARTICLE_SYSTEM))
    //  delete Laser::explosionParticles;
    PRINTF(1)("Deleting Laser Particles\n");
    Laser::explosionParticles = NULL;
  }

}

SpriteParticles* Laser::explosionParticles = NULL;

void Laser::activate()
{
  if (unlikely(Laser::explosionParticles == NULL))
  {
    Laser::explosionParticles = new SpriteParticles(1000);
    Laser::explosionParticles->setName("LaserExplosionParticles");
    Laser::explosionParticles->setLifeSpan(.5, .3);
    Laser::explosionParticles->setRadius(0.0, 10.0);
    Laser::explosionParticles->setRadius(.5, 6.0);
    Laser::explosionParticles->setRadius(1.0, 3.0);
    Laser::explosionParticles->setColor(0.0, 1,1,0,.9);
    Laser::explosionParticles->setColor(0.5, .8,.8,0,.5);
    Laser::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setDamage(20);
  this->setHealth(0);
}


void Laser::deactivate()
{
  assert (Laser::explosionParticles != NULL);
  Laser::explosionParticles->removeEmitter(this->emitter);
  this->lifeCycle = 0.0;

  this->toList(OM_NULL);
  this->removeNode();
  Laser::fastFactory->kill(this);
}


void Laser::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity && entity->isA( "NPC" ))
    this->destroy( entity );
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void Laser::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void Laser::destroy (WorldEntity* killer)
{
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY Laser\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(Laser::explosionParticles);
}


void Laser::draw () const
{
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);

  WorldEntity::draw();
/*  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();
  glPopMatrix();*/

  glPopAttrib();
}

