/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "script_class.h"
#include "script.h"
#include "debug.h"
#include <cassert>

ObjectListDefinition(ScriptClass);

CREATE_SCRIPTABLE_CLASS(Script,
                    addMethod("addObject", Executor2<Script, lua_State*,const std::string&, const std::string& >(&Script::addObject))
                    ->addMethod("registerClass", Executor1<Script, lua_State*,const std::string&>(&Script::registerClass))
                    ->addMethod("selectFunction", Executor2ret<Script, lua_State*, bool, const std::string&, int >(&Script::selectFunction))
                    ->addMethod("executeFunction", Executor0ret<Script, lua_State*,bool >(&Script::executeFunction))
                     );
/**
 * @brief standard constructor
 * @todo this constructor is not jet implemented - do it
*/
ScriptClass::ScriptClass(const std::string& name, const ClassID& classID, ScriptMethod* scriptMethods)
    : BaseObject(name), _classID(classID)
{
  PRINTF(4)("Name %s\n", name.c_str());
  assert(scriptMethods != NULL);
  this->registerObject(this, ScriptClass::_objectList);

  this->_classID = classID;

  this->_scriptMethods = scriptMethods;
}


/**
 * standard deconstructor
*/
ScriptClass::~ScriptClass ()
{
  delete this->_scriptMethods;
}
