/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_classid_list.h"
#include "converter.h"
#include <cassert>


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableClassIDList::SynchronizeableClassIDList( std::map< std::string, int > * ptrIn, std::map< std::string, int > * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 0, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableClassIDList::~SynchronizeableClassIDList ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableClassIDList::writeToBuf( byte * buf, int maxLength )
{
  int res = 0;
  int n;

  std::map< std::string, int >::const_iterator it;
  
  n = Converter::intToByteArray( vPtrIn->size(), buf, maxLength );
  assert( n == INTSIZE );
  res += n;
  
  for ( it = vPtrIn->begin(); it != vPtrIn->end(); it++ )
  {
    n = Converter::stringToByteArray( it->first, buf+res, maxLength-res );
    assert( n == (int)it->first.length()+INTSIZE );
    res += n;
    
    n = Converter::intToByteArray( it->second, buf+res, maxLength-res );
    assert( n == INTSIZE );
    res += n;
  }

  return res;
}

int SynchronizeableClassIDList::getSize()
{
   int res = 0;
   
   std::map< std::string, int >::const_iterator it;
  
   res += INTSIZE;
  
   for ( it = vPtrIn->begin(); it != vPtrIn->end(); it++ )
   {
     res += it->first.length()+2*INTSIZE;
   }
   
   return res;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableClassIDList::readFromBuf( byte * buf, int maxLength )
{
  setHasChanged( false );

  int res = 0;
  int num;
  
  assert( maxLength >= INTSIZE );
  int n = Converter::byteArrayToInt( buf, &num );
  assert( n == INTSIZE );
  res += n;
  
  int id;
  std::string name;
  
  for ( int i = 0; i < num; i++ )
  {
    n = Converter::byteArrayToString( buf+res, name, maxLength-res );
    assert( n > 0 );
    res += n;
    
    n = Converter::byteArrayToInt( buf+res, &id );
    assert( n == INTSIZE );
    res += n;
    
    if ( vPtrOut->find(name) == vPtrOut->end() )
      setHasChanged( true );
    else
    {
      if ( (*vPtrOut)[name] != id )
      {
        setHasChanged( true );
      }
    }
    
    (*vPtrOut)[name] = id;
  }

  return res;
}

/**
 * print out variable value
 */
void SynchronizeableClassIDList::debug( )
{

}


/**
 * reads actual size from buffer. this is used when size is not constant
 * @param buf pointer to data
 * @param maxLength maximal size of data
 * @return same as readFromBuf would return
 */
int SynchronizeableClassIDList::getSizeFromBuf( byte * buf, int maxLength )
{
  int res = 0;
  int num;
  
  assert( maxLength >= INTSIZE );
  int n = Converter::byteArrayToInt( buf, &num );
  assert( n == INTSIZE );
  res += n;
  
  int id;
  std::string name;
  
  for ( int i = 0; i < num; i++ )
  {
    n = Converter::byteArrayToString( buf+res, name, maxLength-res );
    assert( n > 0 );
    res += n;
    
    n = Converter::byteArrayToInt( buf+res, &id );
    assert( n == INTSIZE );
    res += n;
  }

  return res;
}


