/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "ini_file_prefs_reader.h"




/**
 * standard constructor
*/
IniFilePrefsReader::IniFilePrefsReader ( const std::string& fileName )
{
  IniParser iniParser;


  Preferences* prefs = Preferences::getInstance();

  prefs->setUserIni( fileName );

  if ( !iniParser.readFile( fileName ) )
    return;

  for(IniParser::Section::iterator section = iniParser.begin();
      section != iniParser.end();
      ++section)
    for (IniParser::Entry::iterator entry = (*section).begin();
         entry != (*section).end();
         ++entry)
      prefs->setString( (*section).name(), (*entry).name(), (*entry).value(), true );

  /*iniParser.firstVar();

  Preferences* prefs = Preferences::getInstance();

  while ( iniParser.nextVar() )
  {
    prefs->setString( iniParser.getCurrentSection(), iniParser.getCurrentName(), iniParser.getCurrentValue(), true );
  }*/
}


/**
 * standard deconstructor
*/
IniFilePrefsReader::~IniFilePrefsReader ()
{}


