/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

#include "network_log.h"
#include <cassert>
#include <stdarg.h>
/**
 *  the singleton reference to this class
 */
NetworkLog* NetworkLog::singletonRef = NULL;


/**
 * standard constructor
 */
NetworkLog::NetworkLog ()
{
  listensock = NULL;
}


/**
   @brief standard deconstructor
 */
NetworkLog::~NetworkLog ()
{
  NetworkLog::singletonRef = NULL;
}

/**
 * listens on port for connections
 * @param port port number
 * @return true on success
 */
bool NetworkLog::listen( int port )
{
  IPaddress ip;

  if ( SDLNet_ResolveHost( &ip, NULL, port ) == -1 ) {
    PRINT(1)( "SDLNet_ResolveHost: %s\n", SDLNet_GetError() );
    listensock = NULL;
    return false;
  }

  listensock = SDLNet_TCP_Open( &ip );

  if( !listensock ) {
    PRINT(1)( "SDLNet_TCP_Open: %s\n", SDLNet_GetError() );
    return false;
  }

  return true;
}

/**
 * prints string to all connected sockets
 */
void NetworkLog::printfn( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  printfnet();
}

/**
 * accepts new connections
 */
void NetworkLog::acceptNewConnections( )
{
  TCPsocket newSock = SDLNet_TCP_Accept( listensock );

  if ( newSock )
    sockets.push_back( newSock );
}

/**
 * prints to all connected sockets and to PRINTF(0)
 */
void NetworkLog::printf0( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(0)( buf );
  printfnet();

}

/**
 * prints to all connected sockets and to PRINTF(1)
 */
void NetworkLog::printf1( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(1)( buf );
  printfnet();

}

/**
 * prints to all connected sockets and to PRINTF(2)
 */
void NetworkLog::printf2( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(2)( buf );
  printfnet();

}

/**
 * prints to all connected sockets and to PRINTF(3)
 */
void NetworkLog::printf3( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(3)( buf );
  printfnet();

}

/**
 * prints to all connected sockets and to PRINTF(4)
 */
void NetworkLog::printf4( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(4)( buf );
  printfnet();

}

/**
 * prints to all connected sockets and to PRINTF(5)
 */
void NetworkLog::printf5( char * format, ... )
{
  va_list ap;
  va_start( ap, format );

  assert( vsnprintf( buf, NETWORK_LOG_BUFLEN, format, ap ) < NETWORK_LOG_BUFLEN );

  va_end( ap );

  PRINT(5)( buf );
  printfnet();

}


/**
 * prints buf to network sockets
 */
void NetworkLog::printfnet()
{
  if ( !listensock )
    return;

  acceptNewConnections();

  for ( std::list<TCPsocket>::iterator it = sockets.begin(); it != sockets.end(); )
  {
    if ( SDLNet_TCP_Send( *it, buf, strlen( buf) ) < strlen( buf ) )
    {
      SDLNet_TCP_Close( *it );
      std::list<TCPsocket>::iterator delIt = it;
      it++;
      sockets.erase( delIt );
      continue;
    }

    it++;
  }
}
