/*!
 * @file event_listener.h
 *  Definition of an event listener base class
*/

#ifndef _EVENT_LISTENER_H
#define _EVENT_LISTENER_H

#include "base_object.h"
#include "event_def.h"
#include "event.h"

//! A class for event listener
class EventListener : virtual public BaseObject
{
  ObjectListDeclaration(EventListener);
public:
  EventListener();
  virtual ~EventListener();

  bool isEventSubscribed(elState state, int eventType) const;

  void subscribeEvent(elState state, int eventType);
  void unsubscribeEvent(elState state, int eventType);
  void unsubscribeEvents(elState state = ES_ALL);

  /**
   * @brief abstract function that processes events from the handler
   * @param event: the event
   */
  virtual void process(const Event &event) = 0;

};

#endif /* _EVENT_LISTENER_H */
