/*!
 * @file event_def.h
 * some central definitions
*/

#ifndef _EVENT_DEF_H
#define _EVENT_DEF_H

#ifdef HAVE_SDL_H
 #include "SDL_keysym.h"
#else
 #include "SDL/SDL_keysym.h"
#endif

//! these are the extended event types, that are not included in SDL_keysym
typedef enum {
  EV_MOUSE_BUTTON_LEFT           = SDLK_LAST + 1,
  EV_MOUSE_BUTTON_MIDDLE,
  EV_MOUSE_BUTTON_RIGHT,
  EV_MOUSE_BUTTON_WHEELUP,
  EV_MOUSE_BUTTON_WHEELDOWN,
  EV_MOUSE_MOTION,
  EV_JOY_AXIS_MOTION,
  EV_JOY_BALL_MOTION,
  EV_JOY_HAT_MOTION,
  EV_JOY_BUTTON,

  EV_WINDOW_FOCUS,
  EV_VIDEO_RESIZE,

  EV_LEAVE_STATE,
  EV_MAIN_QUIT,

  EV_UNKNOWN,

  EV_NUMBER
} extEventTyes;


//! this is an enumeration of all states of the event_handler/game
typedef enum
{
  ES_NULL         = -1,
  ES_GAME         = 0,       //!< the state during the game plays
  ES_GAME_MENU    = 1,       //!< state when the menu is called during game
  ES_MENU         = 2,       //!< orxonox menu state
  ES_SHELL        = 3,       //!< if we are in shell Modus
  
  ES_ALL          = 4,       //!< you want to register events for all states

  ESTATE_NUMBER   = 5        //!< the number of states < Namespace-problem in windows.
} elState;

#endif /* _EVENT_DEF_H */
