/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file load_param_description.h
 * A Class and macro-functions, that makes our lives easy to load-in parameters
 */

#ifndef _LOAD_PARAM_DESCRIPTION_H
#define _LOAD_PARAM_DESCRIPTION_H

#include <vector>
#include <string>

// Forward Declaration //
class MultiType;

/************************
*** DESCRIPTION STUFF ***
************************/
//! A class that handles the description of loadable parameters
class LoadParamDescription
{
public:
  LoadParamDescription(const std::string& paramName = "");

  //! Compares a LoadParamDescription with a String.
  bool operator==(const std::string& paramName) const { return this->_name == paramName; };
  //! Compares two LoadParamDescription
  bool operator==(const LoadParamDescription& paramDescr) const { return this->_name == paramDescr._name; };
  //! Compares two LoadParamDescription with the less operator
  bool operator<(const LoadParamDescription& paramDescr) const { return this->_name < paramDescr._name; };

  void setDescription(const std::string& descriptionText);
  void setValues(unsigned int paramCount,
                 const MultiType* const defaultValues,
                 bool retVal = false);

  /** @returns the descriptionString */
  const std::string& description() { return this->_description; };

  void print(FILE* stream = stdout, bool withComments = true) const;

private:
  std::string                _name;                  //!< The Name of the Parameter.
  unsigned int               _parameterCount;        //!< The Count of parameters.
  std::string                _description;           //!< A longer description about this function.

  std::vector<std::string>   _types;                 //!< A Vector of types of this Parameter.
  std::vector<std::string>   _defaultValues;         //!< A Vector of defaultValues of this Parameter.
};

#endif /* _LOAD_PARAM_DESCRIPTION_H */
