/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file load_param_class_description.h
 * A Class and macro-functions, that makes our lives easy to load-in parameters
 */

#ifndef _LOAD_PARAM_CLASS_DESCRIPTION_H
#define _LOAD_PARAM_CLASS_DESCRIPTION_H

#include "load_param_description.h"
#include "class_id.h"
#include <map>
// Forward Declaration //
class MultiType;

//! A class for descriptions of a loadable module
class LoadParamClassDescription
{
public:
  LoadParamClassDescription(const std::string& className = "");

  //! Compares a LoadParamClassDescription with a String.
  bool operator==(const std::string& className) const { return this->_className == className; };
  //! Compares two LoadParamClassDescription with each other
  bool operator==(const LoadParamClassDescription& classDescr) const { return this->_className == classDescr._className; };
  //! Compares two LoadParamClassDescription with each other, using the less operator
  bool operator<(const LoadParamClassDescription& classDescr) const { return this->_className < classDescr._className; }


  static void describeClass(const ClassID& classID,
                            const std::string& paramName,
                            const std::string& descriptionText);
  static void setValuesOf(const ClassID& classID,
                          const std::string& paramName,
                          unsigned int paramCount,
                          const MultiType* const defaultValues,
                          bool retVal = false);

  /** @param createThem: if the Parameters should be created/stored. */
  static void captureDescriptions(bool createThem) { _captureDescriptions = createThem; };
  /** @returns if the Parameters are created/stored. */
  static bool descriptionsCaptured() { return _captureDescriptions; };

  static void deleteAllDescriptions();

  void print(FILE* stream = stdout, bool withComments = true) const;
  static void printAll(const std::string& fileName = "", bool withComments = true);
  static void printAllTo(FILE* stream = stdout, bool withComments = true);

private:
  //! A Type definition for the Map of Class Descriptions
  typedef std::map<ClassID, LoadParamClassDescription>  ClassDescriptionMap;
  //! A type definition for the Map of Parameter Descriptions inside of Class-descriptions.
  typedef std::map<std::string, LoadParamDescription>   ParamDescriptionMap;

private:
  static ParamDescriptionMap::iterator getParamDescription(const ClassID& classID, const std::string& paramName);

private:

  static bool                                  _captureDescriptions;    //!< if parameter-description should be enabled globally.

  static ClassDescriptionMap                   _classList;              //!< a list, that stores all the loadable classes. (after one instance has been loaded)

private:
  std::string                                  _className;              //!< name of the class
  ParamDescriptionMap                          _parameters;             //!< List of parameters this class knows.
};

#endif /* _LOAD_PARAM_CLASS_DESCRIPTION_H */
