/*!
 * @file dynamic_loader.h
 * @brief Definition of The Dynamic Loader Factory.
*/

#ifndef _DYNAMIC_LOADER_H
#define _DYNAMIC_LOADER_H

#include "util/loading/factory.h"

#include <string>

#define DYNAMIC_LINKAGE_FACTORY(CLASS_NAME, CLASS_ID) \
          void* DynamicCreator(const TiXmlElement* root) { return new CLASS_NAME(root); };

// FORWARD DECLARATION

//! A class for ...
class DynamicLoader : public Factory
{
  ObjectListDeclaration(DynamicLoader);

public:
  DynamicLoader(const std::string& libName);
  virtual ~DynamicLoader();

  bool loadDynamicLib(const std::string& libName);
  virtual BaseObject* fabricateObject(const TiXmlElement* root = NULL) const;

  static bool loadDyLib(const std::string& libName);


private:
  void*      handle;
};

#endif /* _DYNAMIC_LOADER_H */
