/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file some_shell_commands.cc
 * @brief All the ShellCommands, that should not pollute the SourceCode.
 *
 * This File is here, so that we do not have to pollute the Library-files
 * with unneccessary other modules.
 * Like this
 */

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shell/shell_command.h"
using namespace OrxShell;

#include "network_game_rules.h"
SHELL_COMMAND(say, NetworkGameRules, shellSay)->setAlias("say");

#include "player_stats.h"
SHELL_COMMAND(nick, PlayerStats, shellNick)->setAlias("nick");

// #include "class_list.h"
//   SHELL_COMMAND(debug, ClassList, ClassList::debugS)
//       ->describe("Shows all registered classes, if param1: is a valid ClassName only values of this class are shown. param2: how much output")
//       ->defaultValues(MT_NULL, 1);

#include "p_node.h"
SHELL_COMMAND(debugNode, PNode, debugNode);
SHELL_COMMAND(setPosition, PNode, setAbsCoor);

#include "render_2d.h"
SHELL_COMMAND(toggleNodeVisibility, Render2D, toggleNodesVisibility);


#include "material.h"
SHELL_COMMAND(setDiffuseTexture, Material, setDiffuseMap)
->defaultValues(MT_NULL, (int)GL_TEXTURE_2D)
->completionPlugin(0, CompletorFileSystem());

#include "loading/resource_manager.h"
namespace Resources {
  SHELL_COMMAND(debug, ResourceManager, debug);
  SHELL_COMMAND(load, ResourceManager, loadFromLoadStringHACK);
  SHELL_COMMAND(unload, ResourceManager, unloadAllBelowKeepLevelINT);
}

#include "loading/load_param_class_description.h"
SHELL_COMMAND_STATIC(printAll, LoadParamClassDescription, &LoadParamClassDescription::printAll)
->defaultValues(MT_NULL, true);
SHELL_COMMAND_STATIC(capture, LoadParamClassDescription, &LoadParamClassDescription::captureDescriptions)
    ->defaultValues(true);

#include "loading/game_loader.h"
SHELL_COMMAND(quit, GameLoader, stop)
    ->describe("quits the game")
    ->setAlias("orxoquit");

#include "object_list.h"
SHELL_COMMAND_STATIC(debugAll, ObjectListBase, &ObjectListBase::debugAll);
