/*!
 * @file shell_command_class.h
 * Definition of a on-screen-shell
 */

#ifndef _SHELL_COMMAND_CLASS_H
#define _SHELL_COMMAND_CLASS_H

#include "base_object.h"
#include <vector>
#include <list>

namespace OrxShell
{
  // FORWARD DECLARATION
  class ShellCommand;
  class ShellCommandAlias;
  class ShellCommandClass;

  typedef std::vector<ShellCommand*>      CmdList;
  typedef std::vector<ShellCommandClass*> CmdClassList;


  //! A class to hold all Classes that have (once) registered Commands.
  class ShellCommandClass : public BaseObject
  {
    ObjectListDeclaration(ShellCommandClass);

    friend class ShellCommand;
  public:
    /** @returns the CommandClassList */
    static const CmdClassList& getCommandClassList() { return *ShellCommandClass::_commandClassList; };

    static bool getCommandListOfClass(const std::string& className, std::list<std::string>& stringList);

    static void unregisterAllCommands();
    static ShellCommandClass* getCommandClass(const std::string& className);
    ClassID getClassID();
    static bool exists(const std::string& className);

    static void help (const std::string& className = "");

    static void debug();

  private:
    ShellCommandClass(const std::string& className);
    static ShellCommandClass* acquireCommandClass(const std::string& className);
    virtual ~ShellCommandClass();


    void registerCommand(ShellCommand* command);
    void unregisterCommand(ShellCommand* command);

  private:
    const std::string                      _className;                 //!< The Name of the Class. This should match the ClassName of the Commands Class.
    CmdList                                _commandList;               //!< A list of Commands from this Class

    static CmdClassList*                   _commandClassList;          //!< A list of Classes
  };
}

#endif /* _SHELL_COMMAND_H */
