/*!
 * @file proto_singleton.h
 * @brief Definition of the ... singleton Class
*/

#ifndef _PREFERENCES_H
#define _PREFERENCES_H

#include "base_object.h"
#include "multi_type.h"
#include <list>

// FORWARD DECLARATION

class IniFilePrefsReader;

typedef struct {
  std::string name;
  MultiType value;
  bool modified;
} prefItem;

typedef struct {
  std::string sectionName;
  std::list<prefItem> items;
} prefSection ;


//! A default singleton class.
class Preferences : public BaseObject {
  ObjectListDeclaration(Preferences);
 public:
   virtual ~Preferences(void);
  /** @returns a Pointer to the only object of this Class */
   inline static Preferences* getInstance(void) { if (!singletonRef) singletonRef = new Preferences();  return singletonRef; };

   //check if this entry exists
   bool sectionExists(const std::string& section );
   bool exists(const std::string& section, const std::string& name);

   void setString(const std::string& section, const std::string& name, const std::string& value, bool dontSetModified = false);
   void setInt(const std::string& section, const std::string& name, int value, bool dontSetModified = false);
   void setFloat(const std::string& section, const std::string& name, float value, bool dontSetModified = false);
   void setMultiType(const std::string& section, const std::string& name, const MultiType& value, bool dontSetModified = false);

   std::string getString(const std::string& section, const std::string& name, const std::string& defaultValue);
   int getInt(const std::string& section, const std::string& name, int defaultValue);
   float getFloat(const std::string& section, const std::string& name, float defaultValue);
   MultiType getMultiType(const std::string& section, const std::string& name, const MultiType& defaultValue);

   void setUserIni(const std::string& fileName);

   bool save();

   void debug();

   std::list<std::string> listKeys( const std::string section );


 private:
   Preferences(void);
   static Preferences* singletonRef;

   std::list<prefSection> data;

   std::list<IniFilePrefsReader*> iniFilePrefsReaders;

   std::string fileName;

};

#endif /* _PREFERENCES_H */
