/*!
 * @file proto_class.h
 * @brief Definition of CmdLinePrefsReader
*/

#ifndef _CMD_LINE_PREFS_READER_H
#define _CMD_LINE_PREFS_READER_H

#include "debug.h"

#include "src/lib/parser/cmdline_parser/cmdline_parser.h"

struct IniEntry
{
  std::string section;
  std::string key;
  std::string value;
};

struct CallbackData
{
  std::list<IniEntry> iniEntries;
  CmdLineParser * parser;
};

struct RegistredArgument
{
  char shortOption;
  std::string longOption;
  std::string value;
  std::string help;
  std::string argName;
  std::string section;
  std::string key;
};

typedef std::vector<RegistredArgument> RegistredArgs;

enum
{
  ID_SET_INI = 1,
  ID_HELP,
  ID_PREFS
};

#define REGISTER_ARG_FLAG(shortOption,longOption,section,key,description,value) bool _ARGVAR_##shortOption##_##longOption = CmdLinePrefsReader::registerArgument(#shortOption[0],#longOption,section,key,description,"",value)

#define REGISTER_ARG_ARG(shortOption,longOption,section,key,description,argname) bool _ARGVAR_##shortOption##_##longOption = CmdLinePrefsReader::registerArgument(#shortOption[0],#longOption,section,key,description,argname)

//! A class for reading commandline arguments into Preferences
class CmdLinePrefsReader
{

 public:
   CmdLinePrefsReader();
   virtual ~CmdLinePrefsReader();

    bool parse(int argc, char** argv);

    static bool registerArgument( const char shortOption, const std::string & longOption, const std::string & section, const std::string & key, const std::string & help,  const std::string & argName = "", const std::string & value = "%arg%" );

    static bool asdf;

  private:
    static bool callBack( ArgTableEntry entry, void* data, const std::string & arg, const std::vector<MultiType> & argArgs );

    static RegistredArgs regArgs;

};

#endif /* _PROTO_CLASS_H */
