/*!
 * @file resource_font.h
 * @brief Contains the ResourceFont class, that handles the Resource-specific loading part of the Font.
 *
 */

#ifndef _RESOURCE_FONT_H
#define _RESOURCE_FONT_H

#include "util/loading/resource.h"
#include "font.h"


class ResourceFont : public Font, public Resources::Resource
{
public:
  ResourceFont(const std::string& fontName, unsigned int renderSize, const Resources::KeepLevel& keepLevel = Resources::KeepLevel());
  static ResourceFont createFromString(const std::string& loadString, const Resources::KeepLevel& keepLevel = Resources::KeepLevel());

private:
class FontResourcePointer : public Resources::StorePointer
  {
  public:
    FontResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const FontData::Pointer& data);
    inline const FontData::Pointer& ptr() const { return pointer; }
    virtual bool last() const { return pointer.count() == 1; }
  private:
    FontData::Pointer pointer;
  };

private:
  static Resources::tType<ResourceFont> type;
};


#endif /* _RESOURCE_FONT_H */
