
#include "resource_font.h"
#include "substring.h"
#include "multi_type.h"
#include "debug.h"


ResourceFont::ResourceFont(const std::string& fontName, unsigned int renderSize, const Resources::KeepLevel& keepLevel)
  : Font(), Resource(&ResourceFont::type)
{
  assert(!fontName.empty());
  Resources::StorePointer* ptr = this->acquireResource(fontName + ',' + MultiType((int)renderSize).getString());

  if (ptr)
  {
    PRINTF(5)("FOUND FONT: %s\n", fontName.c_str());
    this->Font::acquireData(static_cast<ResourceFont::FontResourcePointer*>(ptr)->ptr());
  }
  else
  {
    PRINTF(5)("NOT FOUND FONT: %s\n", fontName.c_str());
    std::string fileName = this->Resource::locateFile(fontName);

    this->Font::loadFontFromTTF(fileName, renderSize);
    this->Resource::addResource(new ResourceFont::FontResourcePointer(fontName + ',' + MultiType((int)renderSize).getString(), keepLevel, this->Font::dataPointer()));
  }
}

ResourceFont ResourceFont::createFromString(const std::string& loadString, const Resources::KeepLevel& keepLevel)
{
  SubString loadValues(loadString, ',');
  std::string fontName;
  unsigned int renderSize = 20;
  if (loadValues.size() > 0)
    fontName = loadValues[0];
  if (loadValues.size() > 1)
    renderSize = (unsigned int)MultiType(loadValues[2]).getInt();

  return ResourceFont(fontName, renderSize, keepLevel);
}



Resources::tType<ResourceFont> ResourceFont::type("Font");





ResourceFont::FontResourcePointer::FontResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const FontData::Pointer& data)
    : Resources::StorePointer(loadString, keepLevel) , pointer(data)
{}


