/*!
 * @file multi_line_text.h
 * @brief Definition of a text Class, that is able to render text.
 */

#ifndef _MULTI_LINE_TEXT_H
#define _MULTI_LINE_TEXT_H

#include "text.h"

#include <vector>

//! Represents one textElement.
class MultiLineText : public Text
{
  ObjectListDeclaration(MultiLineText);
  public:
    MultiLineText(const std::string& fontFile = "", unsigned int fontSize = TEXT_DEFAULT_SIZE, float lineWidth = 100.0);

    // Setup:
    void setLineWidth(float lineWidth);
    void setLineSpacing(float lineSpacing);

    // Retrieve:
    /** @returns the LineWidth (maximum distance from the left to the right */
    inline float getLineWidth() const { return this->lineWidth; };
    /** @returns the LineSpacing */
    inline float getLineSpacing() const { return this->lineSpacing; };
    inline unsigned int getLineCount() const { return this->lineCount; };

    virtual void draw() const;

    void debug() const;

  protected:
    virtual void setupTextWidth();

  private:
    float                      lineWidth;
    float                      lineSpacing;
    std::vector<unsigned int>  lineEnds;
    unsigned int               lineCount;
};

#endif /* _MULTI_LINE_TEXT_H */
