/*!
 * @file limited_width_text.h
 * @brief Definition of a text Class, that is able to render text.
 */

#ifndef _LIMITED_WIDTH_TEXT_H
#define _LIMITED_WIDTH_TEXT_H

#include "text.h"

#include <vector>

//! Represents one textElement.
class LimitedWidthText : public Text
{
  ObjectListDeclaration(LimitedWidthText);
  public:
    typedef enum {
      Begin,
      End,
    } DotsPosition;


  public:
    LimitedWidthText(const std::string& fontFile = "", unsigned int fontSize = TEXT_DEFAULT_SIZE, float lineWidth = 100.0, DotsPosition dotsPosition = Begin);

    // Setup:
    void setLineWidth(float lineWidth);
    void setDotsPosition(LimitedWidthText::DotsPosition dotsPosition);

    // Retrieve:
    /** @returns the LineWidth (maximum distance from the left to the right */
    inline float lineWidth() const { return this->_lineWidth; };
    /** @returns the dots position. */
    inline float dotsPosition() const { return this->_dotsPosition; };

    virtual void draw() const;

    void debug() const;

  protected:
    virtual void setupTextWidth();

  private:
    std::string                _dotedText;

    DotsPosition               _dotsPosition;
    float                      _lineWidth;
    unsigned int               _lineEnds;
};

#endif /* _LIMITED_WIDTH_TEXT_H */
