/*!
 * @file render_2d.h
 * @brief Definition of the 2D-rendering engine singleton Class
 */

#ifndef _RENDER_2D_H
#define _RENDER_2D_H

#include "base_object.h"
#include "element_2d.h"
// FORWARD DECLARATION

//! A default singleton class.
class Render2D : public BaseObject
{
  ObjectListDeclaration(Render2D);

  friend class Element2D;

public:
  virtual ~Render2D();
  /** @returns a Pointer to the only object of this Class */
  inline static Render2D* getInstance() { if (!singletonRef) singletonRef = new Render2D();  return singletonRef; };

void toggleNodesVisibility() { this->showNodes = !this->showNodes; };

  void update(float dt);
  void tick(float dt);
  void draw(E2D_LAYER from, E2D_LAYER to) const;

private:
  Render2D();
  static Render2D*              singletonRef;                    //!< Reference to this class.

  bool                          showNodes;                       //!< If the debug-Nodes should be visible
};

#endif /* _RENDER_2D_H */
