/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_LOADING

#include "resource.h"
#include "filesys/file.h"

ObjectListDefinition(NewResource);


std::vector<NewResource::Type*>    NewResource::_resourceTypes;

//! GLOBALS
Directory NewResource::_mainGlobalPath;
std::vector<Directory>        NewResource::_globalPaths;


/**
 * standard constructor
*/
NewResource::NewResource (NewResource::Type* type)
    : _pointer(NULL), _type(type)
{
  this->registerObject(this, NewResource::_objectList);

  if(this->_type->id() == -1)
  {
    NewResource::_resourceTypes.push_back(this->_type);
    this->_type->setID(NewResource::_resourceTypes.size()-1);
  }
}

/**
 * standard deconstructor
 */
NewResource::~NewResource ()
{
  // delete what has to be deleted here
}


std::string NewResource::locateFile(const std::string& fileName)
{
  if (File(fileName).exists())
    return fileName;
  else if ((NewResource::_mainGlobalPath+File(fileName)) . exists() )
    return (NewResource::_mainGlobalPath + File(fileName)).name();

  return std::string("/home/bensch/svn/orxonox/data/") + fileName;

}


NewResource::StorePointer* NewResource::acquireResource(const std::string& loadString)
{
  //const NewResource::Type* const type = NewResource::_resourceTypes[this->_type->id()];

  for (unsigned int i = 0; i < _type->storedResources().size(); ++i)
  {
    if (_type->storedResources()[i]->loadString() == loadString)
      return _type->storedResources()[i];
  }

  return NULL;
}

void NewResource::setMainGlobalPath(const Directory& directory)
{
  NewResource::_mainGlobalPath = directory;
  NewResource::_mainGlobalPath.open();
}

void NewResource::addGlobalPath(const Directory& directory)
{
  std::vector<Directory>::const_iterator it = std::find(NewResource::_globalPaths.begin(), NewResource::_globalPaths.end(), directory);
  if (it == NewResource::_globalPaths.end())
    NewResource::_globalPaths.push_back(directory);
}



void NewResource::addResource(NewResource::StorePointer* pointer)
{
  this->_type->addResource(pointer);
}









std::vector<std::string>  NewResource::KeepLevel::_keepLevelNames;
void NewResource::KeepLevel::defineKeepLevelName(unsigned int level, const std::string& name)
{
  if (_keepLevelNames.size() <= level)
    _keepLevelNames.resize(level+1);
  _keepLevelNames[level] = name;
}



void NewResource::Type::addResource(NewResource::StorePointer* resource)
{
  this->_storedResources.push_back(resource);

}


NewResource::StorePointer::StorePointer(const std::string& loadString, const NewResource::KeepLevel& keeplevel)
    : _loadString(loadString), _keepLevel(keeplevel)
{}


void NewResource::Type::setID(int id)
{
  this->_id = id;
}
