/*!
 * @file resource_texture.h
 * @brief Contains the ResourceTexture class, that handles the Resource-specific loading part of the Texture.
 *
 */

#ifndef _RESOURCE_TEXTURE_H
#define _RESOURCE_TEXTURE_H

#include "util/loading/resource.h"
#include "texture.h"


class ResourceTexture : public Texture, public NewResource
{
public:
  ResourceTexture(const std::string& imageName, GLenum target = GL_TEXTURE_2D);


private:
class TextureResourcePointer : public NewResource::StorePointer
  {
  public:
    TextureResourcePointer(const std::string& loadString, const NewResource::KeepLevel& keepLevel, const TextureData::Pointer& data);
    inline const TextureData::Pointer& ptr() const { return pointer; }
  private:
    TextureData::Pointer pointer;
  };

private:
  static NewResource::Type type;
};


#endif /* _RESOURCE_TEXTURE_H */
