

#include "resource_texture.h"



ResourceTexture::ResourceTexture(const std::string& imageName, GLenum target)
    : NewResource(&ResourceTexture::type)
{
  NewResource::StorePointer* ptr = this->acquireResource(imageName + ',' + "TEST");

  if (ptr)
  {
    printf("FOUNT TEXTURE: %s\n", imageName.c_str());
    this->acquireData(static_cast<ResourceTexture::TextureResourcePointer*>(ptr)->ptr());
  }
  else
  {
    printf("NOT FOUNT TEXTURE: %s\n", imageName.c_str());
    std::string fileName = this->NewResource::locateFile(imageName);
    this->Texture::loadImage(fileName, target);
    this->NewResource::addResource(new ResourceTexture::TextureResourcePointer(imageName + ',' + "TEST", KeepLevel(0), this->Texture::dataPointer()));
  }
}


NewResource::Type ResourceTexture::type(Texture::staticClassID());





ResourceTexture::TextureResourcePointer::TextureResourcePointer(const std::string& loadString, const NewResource::KeepLevel& keepLevel, const TextureData::Pointer& data)
    : NewResource::StorePointer(loadString, keepLevel) , pointer(data)
{}


