/*!
 * @file resource.h
 * @brief Definition of a Resource.
*/

#ifndef _RESOURCE_H
#define _RESOURCE_H

#include "base_object.h"
#include "multi_type.h"
#include <string>
#include <vector>
#include <set>

//! A Resource is an Object, that can be loaded from Disk
/**
 *
 */
class Resource : virtual public BaseObject
{
  ObjectListDeclaration(Resource);
public:
  class KeepLevel
  {
  public:
    void setKeepLevelName(unsigned int level, const std::string& name);
  private:
    std::vector<std::string>     _keepLevelName;
  };

protected:
  class Type
  {
  public:
    Type(const ClassID& classID) : _id(-1), _classID(classID) { };

    void addExtension(const std::string& extension);

    const ClassID& storedClassID() const { return _classID; };
    int id() const { return _id; };
    const std::vector<std::string>& resourcePaths() const { return _resourcePaths; };


    void setID(int id);

  private:
    int                           _id;
    const ClassID&                _classID;
    std::vector<std::string>      _resourcePaths;
    std::vector<std::string>      _resourceSubPaths;
    std::vector<std::string>      _fileExtensions;
  };

  class Pointer {};


public:
  Resource(const std::string& fileName);
  virtual ~Resource();

  bool loadResource(std::string& fileName, Resource::Pointer* ptr);
  virtual bool reload();
  virtual bool unload();



private:
  std::string              _loadString;             //!< An identifier, to match when loading a File.
  std::string              _fileName;
  MultiType                _parameters[3];          //!< The Parameters given to this Resource.
  Resource::KeepLevel      _keepLevel;              //!< The Priority of this resource. (can only be increased, so noone else will delete this)


  static std::vector<Resource::Type>     _resourceTypes;

  //! GLOBALS
  static std::string                     _mainGlobalPath;
  static std::vector<std::string>        _globalPaths;
};

#endif /* _RESOURCE_H */
