/*!
 * @file functor_static.h
 * Definition of Functors to Functions of Static Type
 */

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#ifndef __FUNCTOR_STATIC_H_
#define __FUNCTOR_STATIC_H_

#include "executor_static.h"

/// Define all Constructs, that define an Executor.
//! The Name to be attached to the functional (for normal, static, and const modes)
#define __EXECUTOR_FUNCTIONAL_NAME(ParamCount, Ext)   Executor##ParamCount##Ext##_static
//! if Functional is constant calling
#define __EXECUTOR_FUNCTIONAL_CONST
//! The Function-Pointer, and how to save it internally.
#define __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER   *functionPointer
//! The Type of Function
#define __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE       Executor<CallType, BaseClass>::FunctionStatic

/// Now we include The generic Functor, that generate the functions.
#include "functor_generic.h"


#undef __EXECUTOR_FUNCTIONAL_NAME
#undef __EXECUTOR_FUNCTIONAL_CONST
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER
#undef __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE



#endif /* __FUNCTOR_STATIC_H_ */
