/*!
 * @file functor_list.h
 * all the Different types of Functions one can include by using a simple createExecutor call
 * with a FunctionPointer as Argument
 */
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
*/


#ifdef FUNCTOR_LIST
  FUNCTOR_LIST(0)(FUNCTOR_CALL_TYPE);
  //! makes functions with one string
  FUNCTOR_LIST(1)(FUNCTOR_CALL_TYPE, const std::string&);
  //! makes functions with two strings
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, const std::string&, const std::string&);
  //! makes functions with three strings
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, const std::string&, const std::string&, const std::string&);
  //! makes functions with four strings
  FUNCTOR_LIST(4)(FUNCTOR_CALL_TYPE, const std::string&, const std::string&, const std::string&, const std::string&);


  //! makes functions with one bool
  FUNCTOR_LIST(1)(FUNCTOR_CALL_TYPE, bool);

  //! makes functions with one int
  FUNCTOR_LIST(1)(FUNCTOR_CALL_TYPE, int);
  //! makes functions with two ints
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, int, int);
  //! makes functions with three ints
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, int, int, int);
  //! makes functions with four ints
  FUNCTOR_LIST(4)(FUNCTOR_CALL_TYPE, int, int, int, int);


  //! makes functions with one unsigned int
  FUNCTOR_LIST(1)(FUNCTOR_CALL_TYPE, unsigned int);
  //! makes functions with two unsigned ints
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, unsigned int, unsigned int);
  //! makes functions with three unsigned ints
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, unsigned int, unsigned int, unsigned int);
  //! makes functions with four unsigned ints
  FUNCTOR_LIST(4)(FUNCTOR_CALL_TYPE, unsigned int, unsigned int, unsigned int, unsigned int);

  //! makes functions with one float
  FUNCTOR_LIST(1)(FUNCTOR_CALL_TYPE, float);
  //! makes functions with two floats
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, float, float);
  //! makes functions with three floats
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, float, float, float);
  //! makes functions with four floats
  FUNCTOR_LIST(4)(FUNCTOR_CALL_TYPE, float, float, float, float);
  //! makes functions with four floats
  FUNCTOR_LIST(5)(FUNCTOR_CALL_TYPE, float, float, float, float, float);

  //! mixed values:
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, const std::string&, int);
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, const std::string&, float);
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, unsigned int, long);
  FUNCTOR_LIST(2)(FUNCTOR_CALL_TYPE, const std::string&, unsigned int);

  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, const std::string&, float, unsigned int);
  FUNCTOR_LIST(4)(FUNCTOR_CALL_TYPE, const std::string&, float, unsigned int, unsigned int);
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, const std::string&, int, unsigned int);
  FUNCTOR_LIST(3)(FUNCTOR_CALL_TYPE, const std::string&, unsigned int, unsigned int);

  FUNCTOR_LIST(5)(FUNCTOR_CALL_TYPE, float, float, float, float, const std::string&);

#endif /* FUNCTOR_LIST */
