/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "executor_substring.h"
#include "helper_functions.h"

/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> bool fromString<bool>(const std::string& input, bool defaultValue) { return isBool(input, defaultValue); };
/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> int fromString<int>(const std::string& input, int defaultValue) { return isInt(input, defaultValue); };
/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> unsigned int fromString<unsigned int>(const std::string& input, unsigned int defaultValue) { return isInt(input, defaultValue); };
/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> float fromString<float>(const std::string& input, float defaultValue) { return isFloat(input, defaultValue); };
/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> char fromString<char>(const std::string& input, char defaultValue) { return isInt(input, defaultValue); };
/**
 * @brief converts an input string into a value, if no value was converted, uses defaultValue.
 * @param input the input as a String.
 * @param defaultValue the Default Value set, if the input could not be converted into type.
 * @returns either the converted value or defaultValue.
 */
template<> const std::string& fromString<const std::string&>(const std::string& input, const std::string& defaultValue) { return (input.size() > 0) ? input : defaultValue; };


/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> bool fromMulti<bool>(const MultiType& multi) { return multi.getBool(); };
/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> int fromMulti<int>(const MultiType& multi) { return multi.getInt(); }
/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> unsigned int fromMulti<unsigned int>(const MultiType& multi) { return multi.getInt(); };
/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> float fromMulti<float>(const MultiType& multi) { return multi.getFloat(); };
/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> char fromMulti<char>(const MultiType& multi) { return multi.getChar(); };
/**
 * @brief converts to any type from a MultiType
 * @param multi the MultiType to convert.
 * @returns the converted Value.
 */
template<> const std::string& fromMulti<const std::string&>(const MultiType& multi) { return multi.getConstString(); };


/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> bool getDefault<bool>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getBool(); };
/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> int getDefault<int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> unsigned int getDefault<unsigned int>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getInt(); };
/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> float getDefault<float>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getFloat(); };
/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> char getDefault<char>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getChar(); };
/**
 * @brief retrieves a default value from an array of default values, at possition i.
 * @param defaultValues the Array of default values.
 * @param i the index.
 * @returns the Default Value at Position i
 */
template<> const std::string& getDefault<const std::string&>(const MultiType* const defaultValues, unsigned int i) { return defaultValues[i].getStoredString(); };
