/*!
 * @file executor_static.h
 * Definition of an Executor to Static Functions (either Static-Class or C-Style)
 */
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#ifndef __EXECUTOR_STATIC_H_
#define __EXECUTOR_STATIC_H_

/// Define all Constructs, that define an Executor.

//! The Name to be attached to the functional (for normal, static, and const modes)
#define __EXECUTOR_FUNCTIONAL_NAME(ParamCount, Ext)   Executor##ParamCount##Ext##_static

//! if Functional is constant calling
#define __EXECUTOR_FUNCTIONAL_CONST
//! The Execution-mode (either static or objective)
#define __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC      functionPointer
//! The Function-Pointer, and how to save it internally.
#define __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER   *functionPointer
//! The Type of Function
#define __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE       Executor<CallType, BaseClass>::FunctionStatic


/// We want to include __EXECUTOR_GENERIC_H again, with current settings.
#include "executor_generic.h"

#undef __EXECUTOR_FUNCTIONAL_NAME

#undef __EXECUTOR_FUNCTIONAL_CONST
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER
#undef __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE

#endif /* __EXECUTOR_STATIC_H_ */
