/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "executor_lua_state.h"

#include "lunar.h"

std::string temp[7];

/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<typename type> type fromLua(lua_State* state, int index) { type *obj = Lunar<type>::check(state, 1); lua_remove(state, 1); return obj;};
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> bool fromLua<bool>(lua_State* state, int index) { return lua_toboolean(state, index); };
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> int fromLua<int>(lua_State* state, int index) { return (int)lua_tonumber(state, index); };
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> unsigned int fromLua<unsigned int>(lua_State* state, int index) { return (unsigned int)lua_tonumber(state, index); };
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> float fromLua<float>(lua_State* state, int index) { return (float)lua_tonumber(state, index); };
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> char fromLua<char>(lua_State* state, int index) { return (char)lua_tonumber(state, index); };
/**
 * @brief Converts a lua_State into any type.
 * @param state the State to get the value from.
 * @param index the position inside of the lua_State to get the value from.
 * @returns The value if found.
 */
template<> const std::string& fromLua<const std::string&>(lua_State* state, int index) { temp[index] = lua_tostring(state, index); return temp[index]; };




/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<typename type> void toLua(lua_State* state, type value) { Lunar<type>::push(state, value, false); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<bool>(lua_State* state, bool value) { lua_pushboolean(state, (int) value); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<int>(lua_State* state, int value)  { lua_pushnumber(state, (lua_Number) value); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<unsigned int>(lua_State* state, unsigned int value){ lua_pushnumber(state, (lua_Number) value); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<float>(lua_State* state, float value) { lua_pushnumber(state, (lua_Number) value); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<char>(lua_State* state, char value) { lua_pushnumber(state, (lua_Number) value); };
/**
 * @brief writes a value into a lua_State.
 * @param state the state to write into.
 * @param value the Value of type to write into the State.
 */
template<> void toLua<const std::string&>(lua_State* state, const std::string& value) { lua_pushstring (state, value.c_str()); }
