/*!
 * @file executor_functional.h
 * Definition of an Executor
 */

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#ifndef __FUNCTOR_MEMBER_H_
#define __FUNCTOR_MEMBER_H_

#include "executor_member.h"
#include "substring.h"

// // // // // // // // // // // // //
//// EXTENSION TO HIDE CONSTRUCT /////
// // // // // // // // // // // // //
/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 */
#define EXECUTOR_FUNCTIONAL_CREATOR0() \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)() __EXECUTOR_FUNCTIONAL_CONST) \
{ \
  return new __EXECUTOR_FUNCTIONAL_NAME(0)<T, const SubString>(functionPointer); \
}

/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 * @param type0 for internal usage: the first Argument
 */
#define EXECUTOR_FUNCTIONAL_CREATOR1(type0) \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0) __EXECUTOR_FUNCTIONAL_CONST) \
{ \
  return new __EXECUTOR_FUNCTIONAL_NAME(1)<T, const SubString, type0>(functionPointer); \
}

/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 * @param type0 for internal usage: the first Argument
 * @param type1 for internal usage: the second Argument
 */
#define EXECUTOR_FUNCTIONAL_CREATOR2(type0, type1) \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1) __EXECUTOR_FUNCTIONAL_CONST) \
{ \
  return new __EXECUTOR_FUNCTIONAL_NAME(2)<T, const SubString, type0, type1>(functionPointer); \
}

/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 * @param type0 for internal usage: the first Argument
 * @param type1 for internal usage: the second Argument
 * @param type2 for internal usage: the third Argument
 */
#define EXECUTOR_FUNCTIONAL_CREATOR3(type0, type1, type2) \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1, type2) __EXECUTOR_FUNCTIONAL_CONST) \
{ \
  return new __EXECUTOR_FUNCTIONAL_NAME(3)<T, const SubString, type0, type1, type2>(functionPointer); \
}

/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 * @param type0 for internal usage: the first Argument
 * @param type1 for internal usage: the second Argument
 * @param type2 for internal usage: the third Argument
 * @param type3 for internal usage: the fourth Argument
 */
#define EXECUTOR_FUNCTIONAL_CREATOR4(type0, type1, type2, type3) \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1, type2, type3) __EXECUTOR_FUNCTIONAL_CONST) \
{ \
  return new __EXECUTOR_FUNCTIONAL_NAME(4)<T, const SubString, type0, type1, type2, type3>(functionPointer); \
}

/**
 * @brief enables us to easily retrieve an Executor of Class T with modular Argument-count, (without thinking about args at all)
 * @param type0 for internal usage: the first Argument
 * @param type1 for internal usage: the second Argument
 * @param type2 for internal usage: the third Argument
 * @param type3 for internal usage: the fourth Argument
 * @param type4 for internal usage: the fifth Argument
 */
#define EXECUTOR_FUNCTIONAL_CREATOR5(type0, type1, type2, type3, type4) \
template<class T> Executor<const SubString>* createExecutor(void (__EXECUTOR_FUNCTIONAL_FUNCTION_POINTER)(type0, type1, type2, type3, type4) __EXECUTOR_FUNCTIONAL_CONST) \
{ \
    return new __EXECUTOR_FUNCTIONAL_NAME(5)<T, const SubString, type0, type1, type2, type3, type4>(functionPointer); \
}

/**
 * Creates the FunctionCallers imediately
 */
#define FUNCTOR_LIST(x) EXECUTOR_FUNCTIONAL_CREATOR ## x
#include "functor_list.h"
#undef FUNCTOR_LIST


#undef __EXECUTOR_FUNCTIONAL_NOT_INCLUDE_THIS
