/*!
 * @file executor_member.h
 * Definition of an Executor to Member Functions
 */
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#ifndef __EXECUTOR_CONST_MEMBER_H_
#define __EXECUTOR_CONST_MEMBER_H_

/// Define all Constructs, that define an Executor.

//! The Name to be attached to the functional (for normal, static, and const modes)
#define __EXECUTOR_FUNCTIONAL_NAME(ParamCount)   Executor##ParamCount##Params_const

//! if Functional is constant calling
#define __EXECUTOR_FUNCTIONAL_CONST              const
//! The Execution-mode (either static or objective)
#define __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC      dynamic_cast<T*>(object)->*(functionPointer)
//! The Function-Pointer, and how to save it internally.
#define __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER   T::*functionPointer
//! The Type of Function
#define __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE       Executor<CallType, BaseClass>::FunctionConstMember


/// We want to include __EXECUTOR_GENERIC_H again, with current settings.
#ifdef __EXECUTOR_GENERIC_H
#undef __EXECUTOR_GENERIC_H
#include "executor_generic.h"

#undef __EXECUTOR_FUNCTIONAL_NAME

#undef __EXECUTOR_FUNCTIONAL_CONST
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_EXEC
#undef __EXECUTOR_FUNCTIONAL_FUNCTION_POINTER
#undef __EXECUTOR_FUNCTIONAL_FUNCTIONTYPE

#endif /* __EXECUTOR_CONST_MEMBER_H_ */
