/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "new_class_id.h"
#include <cassert>
#include "debug.h"

///////////////////////////////////////////////////////////
//// CLASS ID definiton. //////////////////////////////////
///////////////////////////////////////////////////////////
/**
 * @brief standard constructor
 */
NewClassID::NewClassID ()
{}


/**
 * @brief standard deconstructor
 */
NewClassID::~NewClassID ()
{
  //  assert(_objectList != NULL);
  ClassList::iterator it;
  for (it = this->_classes.begin(); it != this->_classes.end(); ++it)
  {
    (*it)._objectList->unregisterObject((*it)._iterator);
    delete (*it)._iterator;
  }
  //_objectList->unregisterObject(this->_iterators);
}


/**
 * @brief Seeks in the Inheritance if it matches objectList.
 * @param objectList The ObjectList this should be a member of (by Pointer-comparison).
 * @return True if found, false if not.
 */
bool NewClassID::isA(const NewObjectListBase& objectList) const
{
  ClassList::const_iterator it;
  for (it = this->_classes.begin(); it != this->_classes.end(); ++it)
    if ((*it)._objectList == &objectList)
      return true;
  return false;
}

/**
 * @brief Seeks in the Inheritance if it matches objectList.
 * @param classID The ClassID of the class this should be a member of.
 * @return True if found, false if not.
 */
bool NewClassID::isA(int classID) const
{
  ClassList::const_iterator it;
  for (it = this->_classes.begin(); it != this->_classes.end(); ++it)
    if (*(*it)._objectList == classID)
      return true;
  return false;
}

/**
 * @brief Seeks in the Inheritance if it matches objectList.
 * @param className The ClassName of the class this should be a member of.
 * @return True if found, false if not.
 */
bool NewClassID::isA(const std::string& className) const
{
  ClassList::const_iterator it;
  for (it = this->_classes.begin(); it != this->_classes.end(); ++it)
    if (*(*it)._objectList == className)
      return true;
  return false;
}


void NewClassID::listInheritance() const
{
  PRINT(0)("Listing inheritance diagram for ....: ");
  ClassList::const_iterator it;
  for (it = this->_classes.begin(); it != this->_classes.end(); ++it)
    PRINT(0)(" -> %s(id:%d)", (*it)._objectList->name().c_str(), (*it)._objectList->id());
  PRINT(0)("\n");

}
