/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "new_object_list.h"
#include <cassert>


NewObjectListBase::NewObjectListBase(const std::string& className)
    : _id(-1), _name(className)
{
  if (NewObjectListBase::_classesByID == NULL)
  {
    NewObjectListBase::_classesByID = new classIDMap;
    assert (NewObjectListBase::_classesByName == NULL);
    NewObjectListBase::_classesByName = new classNameMap;
  }
  assert(!NewObjectListBase::classNameExists(className) && "Classes should only be included once, and no two classes should have the same name/ID (key value)");


  this->_id = NewObjectListBase::_idCounter++;

  (*NewObjectListBase::_classesByID)[this->_id] = this;
  (*NewObjectListBase::_classesByName)[this->_name] = this;
}

NewObjectListBase::~NewObjectListBase()
{
  NewObjectListBase::_classesByName->erase(this->_name);
  NewObjectListBase::_classesByID->erase(this->_id);

  if (NewObjectListBase::_classesByID->empty())
  {
    delete NewObjectListBase::_classesByID;
    NewObjectListBase::_classesByID = NULL;
    assert(NewObjectListBase::_classesByName != NULL);
    delete NewObjectListBase::_classesByName;
    NewObjectListBase::_classesByName = NULL;
  }
}

int NewObjectListBase::_idCounter = 0;
NewObjectListBase::classIDMap* NewObjectListBase::_classesByID = NULL;
NewObjectListBase::classNameMap* NewObjectListBase::_classesByName = NULL;



/**
 * @brief Checks if a Class with name already exists.
 * @param name The Name of the Class to check.
 * @return true if such a class already exists.
 */
bool NewObjectListBase::classNameExists(const std::string& name)
{
  return (NewObjectListBase::_classesByName->find(name) != NewObjectListBase::_classesByName->end());
  //  classNameMap::iterator it;
  //   for (it = NewObjectListBase::_classesByID->begin(); it != NewObjectListBase::_classesByID->end(); it++)
  //     if(*it != NULL && (*it)->name() != name)
  //       return true;
  //   return false;
}


/**
 * @brief Converts an ID into a ClassName String.
 * @param classID The ID to convert.
 * @return The ClassName or an empty string if the ID was not found.
 */
const std::string& NewObjectListBase::IDToString(int classID)
{
  assert (NewObjectListBase::_classesByID != NULL);
  NewObjectListBase::classIDMap::iterator it = NewObjectListBase::_classesByID->find(classID);
  if (it != NewObjectListBase::_classesByID->end())
    return (*it).second->name();
  else
  {
    static std::string empty;
    return empty;
  }
}


/**
 * @brief Converts a String into an ID
 * @param className the Name of the Class to search for
 * @return The Classes ID if found, -1 otherwise.
 */
int NewObjectListBase::StringToID(const std::string& className)
{
  assert (NewObjectListBase::_classesByName != NULL);
  NewObjectListBase::classNameMap::iterator it = NewObjectListBase::_classesByName->find(className);
  if (it != NewObjectListBase::_classesByName->end())
    return (*it).second->id();
  else
    return -1;
}

