#include "new_class_id.h"
#include "new_object_list.h"
#include <iostream>

class BaseObject
{
  public:
    void setName(const std::string& name) { this->_objectName = name; };
  const std::string& name() const { return _objectName; };
  bool operator==(const std::string& name) const { return _objectName == name; };

  NewObjectListDeclaration(BaseObject);


protected:
  BaseObject(const std::string& objectName = "") : _objectName(objectName) { this->registerObject(this, objectList); };
  template<class T>
      inline void registerObject(T* object, NewObjectList<T>& objectList) { _id.registerObject(object, objectList); };
  private:
  NewClassID    _id;
  std::string   _objectName;


};
NewObjectListDefinition(BaseObject);


class Test : public BaseObject
{
public:
  Test();
  ~Test();


  NewObjectListDeclaration(Test);
  //ObjectListDeclaration(Test);
};
NewObjectListDefinition(Test);

Test::Test()
{
  this->registerObject(this, Test::objectList);
  std::cout << "Test()\n";
};
Test::~Test()
{ std::cout << "~Test()\n"; }

class Bone : public BaseObject
{
public:
  Bone() {
    this->registerObject(this, Bone::objectList);
    std::cout << "Bone()\n"; };
  ~Bone() { std::cout << "~Bone()\n"; };
  NewObjectListDeclaration(Bone);
};
NewObjectListDefinition(Bone);

int main()
{
  Test* test = new Test();
  test->setName("Test-object");

  Test::objectList.debug();


  Test::objectList.debug();
  Bone* bone = new Bone();
  bone->setName("Bone-object");

  std::cout << "Here is debug of all Classes\n";
  BaseObject::objectList.debug();
  delete bone;
  delete test;

}

