/*!
 * @file new_class_id.h
 * @brief Definition of a dynamically allocating ClassID
 *
 */

#ifndef _NEW_CLASS_ID_H
#define _NEW_CLASS_ID_H

#include "type_info.h"
#include <string>
#include <list>
#include "new_object_list.h"




//! A class to dynamically allocate ClassID's and support a isA operator
class NewClassID
{
public:
  NewClassID();
  ~NewClassID();

  template<class T> void registerObject(T* object, NewObjectList<T>& list);

private:
  std::list<NewObjectListBase::ClassEntry>       _classes;
};


template<class T>
    inline void NewClassID::registerObject(T* object, NewObjectList<T>& objectList)
{
  this->_classes.push_back(NewObjectListBase::ClassEntry(&objectList, objectList.registerObject(object)));

  /*  this->_objectList = &objectList;
  _iterators.push_back(objectList.registerObject(object, this->_objectList));*/
}

#endif /* _NEW_CLASS_ID_H */
