/*!
 * @file new_class_id.h
 * @brief Definition of a dynamically allocating ClassID
 *
 */

#ifndef _NEW_CLASS_ID_H
#define _NEW_CLASS_ID_H

#include "type_info.h"
#include <string>

#include "new_object_list.h"




//! A class to dynamically allocate ClassID's and support a isA operator
class NewClassID
{
public:
  NewClassID();
  ~NewClassID();

  template<class T> void registerObject(T* object, NewObjectList<T>& list);

private:
  NewObjectListBase*            _objectList;
};


template<class T> void NewClassID::registerObject(T* object, NewObjectList<T>& objectList)
{
  this->_objectList = &objectList;
  objectList.registerObject(object);
}

#endif /* _NEW_CLASS_ID_H */
