/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "new_object_list.h"
#include <cassert>


NewObjectListBase::NewObjectListBase(const std::string& className)
    : _id(-1), _name(className)
{
  if (NewObjectListBase::_classes == NULL)
    NewObjectListBase::_classes = new cList;
  assert(!NewObjectListBase::classNameExists(className) && "Classes should not be included once, and no two classes should have the same name (key value)");

  this->_id = NewObjectListBase::_idCounter++;


}

NewObjectListBase::~NewObjectListBase()
{

}

int NewObjectListBase::_idCounter = 0;
NewObjectListBase::cList* NewObjectListBase::_classes = NULL;



/**
 * @brief Checks if a Class with name already exists.
 * @param name The Name of the Class to check.
 * @return true if such a class already exists.
 */
bool NewObjectListBase::classNameExists(const std::string& name)
{
  cList::iterator it;
  for (it = NewObjectListBase::_classes->begin(); it != NewObjectListBase::_classes->end(); it++)
    if(*it != NULL && (*it)->name() != name)
      return true;
  return false;
}
