/*!
 * @file new_object_list.h
 * @brief Definition of a dynamically allocating ClassID
 *
 */

#ifndef _NEW_OBJECT_LIST_H
#define _NEW_OBJECT_LIST_H

#include "type_info.h"
#include <set>
#include <string>

#define DeclareClass(ClassName) \
   NewObjectList ClassID_##ClassName(ClassName)

#define DeclareInClass(ClassName) \
   NewObjectList objectList(ClassName)

class NewObjectListBase
{
public:
  int id() const { return _id; };
  const std::string& name() const { return _name; };

  static int classCount() { return _idCounter; };

  bool compareName(const NewObjectListBase& more) { return this->_name < more.name(); };
  bool compareID(const NewObjectListBase& more) { return this->_id < more.id(); };

protected:
  NewObjectListBase(const std::string& className);
  ~NewObjectListBase();
private:
  NewObjectListBase(const NewObjectListBase&);

  static bool exists(const std::string& className);

private:
  int                           _id;
  std::string                   _name;

private:
  typedef std::set<NewObjectListBase*>  cList;

  static int                           _idCounter;      //!< A counter, that gives all classes a Unique ClassID. Access to this Variable is to be Thread-Safe.
  static cList*                        _classes;        //!< A Set of all the classes in existance.
};


/////////////////////////
//// TEMPLATISATION /////
/////////////////////////
template<class T> class NewObjectList : public NewObjectListBase
{
public:
  NewObjectList(const std::string& name);
  ~NewObjectList();

private:
  //! the copy constructor will be hidden.
  NewObjectList(const NewObjectList& definer) {};
};

template <class T>
NewObjectList<T>::NewObjectList(const std::string& name)
    : NewObjectListBase(name)
{}

template <class T>
NewObjectList<T>::~NewObjectList()
{}


#endif /* _NEW_OBJECT_LIST_H */
