/*!
 * @file new_class_id.h
 * @brief Definition of a dynamically allocating ClassID
 *
 */

#ifndef _NEW_CLASS_ID_H
#define _NEW_CLASS_ID_H

#include "type_info.h"
#include <set>
#include <string>

#define DeclareClass(ClassName) \
   ClassIDDeclaration ClassID_##ClassName(ClassName)

class ClassIDDeclaration
{
  friend class NewClassID;
public:
  ClassIDDeclaration(const std::string& name);
  ~ClassIDDeclaration();

  int id() const { return _id; };
  const std::string& name() const { return _name; };

private:
  //! the copy constructor will be hidden.
  ClassIDDeclaration(const ClassIDDeclaration& definer) {};

private:
  int                   _id;
  std::string           _name;
};


//! A class to dynamically allocate ClassID's and support a isA operator
class NewClassID
{
public:
  NewClassID();
  ~NewClassID();



  static int classCount() { return _idCounter; };
  static void registerClass(ClassIDDeclaration* namer);
  static void unregisterClass(ClassIDDeclaration* namer);

private:
  std::set<ClassIDDeclaration>  _types;
  std::string                   _className;

  static int                    _idCounter;      //!< A counter, that gives all classes a Unique ClassID. Access to this Variable is to be Thread-Safe.
};


#endif /* _NEW_CLASS_ID_H */
