/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "new_class_id.h"
#include <cassert>

ClassIDDeclaration::ClassIDDeclaration(const std::string& name)
  : _id(-1), _name(name)
{
  NewClassID::registerClass(this);
}

ClassIDDeclaration::~ClassIDDeclaration()
{
  NewClassID::unregisterClass(this);
}



///////////////////////////////////////////////////////////
//// CLASS ID definiton. //////////////////////////////////
///////////////////////////////////////////////////////////
/**
 * @brief standard constructor
 */
NewClassID::NewClassID ()
  : _className("")
{
}


/**
 * @brief standard deconstructor
 */
NewClassID::~NewClassID ()
{
  // delete what has to be deleted here
}


int NewClassID::_idCounter = 0;

//! TODO make access to the idCounter ThreadSafe!
void NewClassID::registerClass(ClassIDDeclaration* namer)
{
  assert (namer->id() != -1 && "Do not register any ClassID's for yourself.");

  namer->_id = NewClassID::_idCounter++;
}

void NewClassID::unregisterClass(ClassIDDeclaration* namer)
{
  // here nothing is done, because Classes cannot be realigned fast.
}
