
/*!
 * @file timer.h
 * @brief Definition of Time Class.
 *
 * Here is a Class that is for measuring time,
 * getting the current time, and stepping through time.
 *
 * @todo: Implement:
 * 1. TimeStep
 * 2. ApproxTimer
 * 3. Class that handles the time-stepping
 * 4. Transformations from one time-coding into another:
 * 5. debug of Timer.
 */

#ifndef __TIMER_H__
#define __TIMER_H__

//! A class to handle time itself
class Timer
{
public:
  Timer();
  Timer(int time);

  void debug() const;

  /// STATIC PUBLIC MEMBERS
  static double getNow();

  private:
    double         _lastTime;
    double         _timeStep;

};

#endif /* __TIMER_H__ */
