/**
 * @file timer.cc
 * @brief A Timer class, that handles all about time.
 *
 * code borrowed from audiere. http://www.audiere.org
 */

#include "timer.h"


#include <time.h>
#include <sys/time.h>

#ifdef __WIN32__
#include <windows.h>
int gettimeofday
      (struct timeval* tp, void* tzp) {
    DWORD t;
    t = timeGetTime();
    tp->tv_sec = t / 1000;
    tp->tv_usec = 1000 * (t % 1000 );
    /* 0 indicates success. */
    return 0;
}
#endif

/**
 * @returns the current time in Second exact to the micro-second
 */
double Timer::getNow() {

#if HAVE_CLOCK_GETTIME

   // use the POSIX realtime clock to get the current time
    struct timespec tp;
    int result = clock_gettime(CLOCK_REALTIME, &tp);
    if (result == 0) {
      return tp.tv_sec * tp.tv_nsec / 1000000000.0;
    }
#endif

    // can't use realtime clock!  Try to use gettimeofday
    struct timeval tv;
    gettimeofday(&tv, 0);
    return tv.tv_sec + tv.tv_usec / 1000000.0;
}

