
/*!
 * @file smooth.h
 * @brief Definition of Smooth Class.
 */

#ifndef __SMOOTH_H__
#define __SMOOTH_H__

namespace VariableHandler
{


  template <typename var_type = float> class LinearIteration
  {
    public:
      static void step(var_type* current, const var_type& fromValue, const var_type& toValue, float stepping);
      static bool reached(const var_type& current, const var_type& toValue) const;
  };


  //! A class to handle smoothness of Variables.
  /** With this smoothing can be achived for many different types of variables.
   */
  template <typename var_type = float, class iteration_type = LinearIteration<var_type> > class Smooth
  {
    public:
      Smooth();

      const var_type& from() const { return _from; }
      const var_type& current() const { return _current; };
      const var_type& to() const { return _to; }

      inline void tick(float dt) { if (!iteration_type::reached(_current, _to)) iteration_type::step(&_current, _from, _to, dt); };

    private:
      var_type     _from;
      var_type     _current;
      var_type     _to;
  };
}
#endif /* __SMOOTH_H__ */
