/*!
 * @file color.h
 * @brief Definition of color-calculations
 *
 * TODO CONVERT THE VECTORS to COLORS!!
 *
 * code borrowed from:
 * http://www.easyrgb.com/math.php
*/

#ifndef _COLOR_H
#define _COLOR_H

#include "vector.h"

//! a very abstract Class that helps transforming Colors into different Systems
class Color
{
public:
  Color(float r = 0.0f, float g = 0.0f, float b = 0.0f, float a = 1.0f) { _rgba[0] = r; _rgba[1] = g; _rgba[2] = b; _rgba[3] = a; };
  Color(const Color& c) { _rgba[0] = c.r(); _rgba[1] = c.g(); _rgba[2] = c.b(); _rgba[3] = c.a(); }

  inline const Color& operator=(const Color& c) { _rgba[0] = c.r(); _rgba[1] = c.g(); _rgba[2] = c.b(); _rgba[3] = c.a(); return *this; };
  inline bool operator==(const Color& c) const { return (r() == c.r() && g() == c.g() && b() == c.b() && a() == c.a()); };

  inline float& operator[](unsigned int i) { return _rgba[i]; }
  inline const float& operator[](unsigned int i) const { return _rgba[i]; }

  inline float r() const { return _rgba[0]; }
  inline float& r() { return _rgba[0]; }
  inline float g() const { return _rgba[1]; }
  inline float& g() { return _rgba[1]; }
  inline float b() const { return _rgba[2]; }
  inline float& b() { return _rgba[2]; }
  inline float a() const { return _rgba[3]; }
  inline float& a() { return _rgba[3]; }




  void setColor(float r = 0.0f, float g = 0.0f, float b = 0.0f, float a = 1.0f) { _rgba[0] = r; _rgba[1] = g; _rgba[2] = b; _rgba[3] = a; };
  void setColor(const Color& c) { r() = c.r();  g()= c.g(); b() = c.b(); a() = c.a(); };

  inline float dist(const Color& c) const { return (sqrt((r()-c.r())*(r()-c.r()) + (g()-c.g())*(g()-c.g()) + (b()-c.b())*(b()-c.b()) + (a()-c.a())*(a()-c.a()))); }
  /// Maths
  inline const Color& operator+=(const Color& c) { r()+=c.r(); g()+=c.g(); b()+=c.b(); a()+=c.a(); return *this; };
  inline Color operator+(const Color& c) const { return Color(r()+c.r(), g()+c.g(), b()+c.b(), a()+c.a()); };
  inline const Color& operator-=(const Color& c) { r()-=c.r(); g()-=c.g(); b()-=c.b(); a()-=c.a(); return *this; };
  inline Color operator-(const Color& c) const { return Color(r()-c.r(), g()-c.g(), b()-c.b(), a()-c.a()); };
  inline const Color& operator*=(float v) { r()*=v, g()*=v, b()*=v, a()*=v; return *this; };
  inline Color operator*(float v) const { return Color(r()*v, g()*v, b()*v, a()*v); };

  void slerp(const Color& c, float v) { *this += (c - *this) * v; };
  void slerpHSV(const Color& c, float v);

  static Color slerpHSVColor(const Color& from, const Color& to, float v);

  void debug() const;

  /// STATIC TRANSFORMATIONS
public:
  static Vector RGBtoHSV (const Vector& RGB);
  static void RGBtoHSV (const Vector& RGB, Vector& HSV);
  static Vector HSVtoRGB (const Vector& HSV);
  static void HSVtoRGB (const Vector& HSV, Vector& RGB);

private:
  static float minrgb(float r, float g, float b);
  static float maxrgb(float r, float g, float b);

public:
  static const Color red;
  static const Color green;
  static const Color blue;
  static const Color white;
  static const Color black;
  static const Color orx;

private:
  float       _rgba[4]; //!< Color Values

  /*  float       _r;     //!< Red Value.
  float       _g;     //!< Green Value.
  float       _b;     //!< Blue Value.
  float       _a;     //!< Alpha Value.*/
};

#endif /* _COLOR_H */
